#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

const int INF = numeric_limits<int>::max();

int main() {
    int T;
    cin >> T;

    for (int t = 0; t < T; ++t) {
        int N, S;
        cin >> N >> S;

        vector<int> m(N), a(N), l(N), r(N);

        for (int i = 0; i < N; ++i) {
            cin >> m[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> a[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> l[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> r[i];
        }

        vector<vector<int>> dp(N + 1, vector<int>(2 * S + 1, -INF));

        dp[0][S + S] = S;

        for (int i = 0; i < N; ++i) {
            for (int j = 0; j <= 2 * S; ++j) {
                if (dp[i][j] != -INF) {
                    // Option 1: Multiply by mi
                    int next_size = dp[i][j] * m[i];
                    int next_pos = min(2 * S, max(0, j + next_size));
                    dp[i + 1][next_pos] = max(dp[i + 1][next_pos], next_size);

                    // Option 2: Add ai
                    next_size = dp[i][j] + a[i];
                    next_pos = min(2 * S, max(0, j + next_size));
                    dp[i + 1][next_pos] = max(dp[i + 1][next_pos], next_size);
                }
            }
        }

        int max_size = -INF;

        for (int j = S; j <= 2 * S; ++j) {
            if (dp[N][j] != -INF && j - S >= l[N - 1] && j - S <= r[N - 1]) {
                max_size = max(max_size, dp[N][j]);
            }
        }

        if (max_size == -INF) {
            cout << "nemoguce" << endl;
        } else {
            cout << max_size << endl;
        }
    }

    return 0;
}